/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.whistle;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableTE;
import com.simibubi.create.content.contraptions.components.structureMovement.StructureTransform;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.schedule.Schedule;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleEntry;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.logistics.trains.management.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ConductorWhistleFlagTileEntity
extends SmartTileEntity
implements ITransformableTE {
    public TrackTargetingBehaviour<GlobalStation> station;
    private boolean tickedOnce = false;
    private DyeColor color = DyeColor.RED;

    public ConductorWhistleFlagTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(100);
    }

    protected String targetStationName() {
        return "<ConductorFlag>" + this.m_58899_().m_123344_();
    }

    DyeColor getColor() {
        return this.color;
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.station.getEdgePoint() == null) {
            this.station.tick();
        }
        if (this.station.getEdgePoint() != null) {
            ((GlobalStation)this.station.getEdgePoint()).name = this.targetStationName();
        }
        if (this.tickedOnce) {
            boolean found = false;
            for (Train train : Create.RAILWAYS.trains.values()) {
                DestinationInstruction destInst;
                ScheduleInstruction scheduleInstruction;
                Schedule schedule = train.runtime == null ? null : train.runtime.getSchedule();
                if (schedule == null || schedule.entries.size() != 1 || !((scheduleInstruction = ((ScheduleEntry)schedule.entries.get((int)0)).instruction) instanceof DestinationInstruction) || (destInst = (DestinationInstruction)scheduleInstruction).getData() == null || !destInst.getData().m_128461_("Text").equals(this.targetStationName())) continue;
                if (!train.runtime.completed) {
                    found = true;
                    break;
                }
                train.runtime.discardSchedule();
            }
            if (!found) {
                this.f_58857_.m_7731_(this.m_58899_(), Blocks.f_50016_.m_49966_(), 3);
                return;
            }
        } else {
            this.tickedOnce = true;
        }
    }

    public void transform(StructureTransform transform) {
        this.station.transform(transform);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.station = new TrackTargetingBehaviour((SmartTileEntity)this, EdgePointType.STATION);
        behaviours.add((TileEntityBehaviour)this.station);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128344_("SelectedColor", ConductorEntity.idFrom(this.color));
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.color = ConductorEntity.colorFrom(tag.m_128445_("SelectedColor"));
    }
}

